#ifndef _CCL_DD_H
#define _CCL_DD_H
/* Datatype to facilitate transfer of image pixel data to and fro between user space and kernel space */
typedef struct {
  unsigned char *pix_data;
  unsigned int pix_count;
} img_row_arg_t;


/* Datatype to facilitate transfer of commands and status notifications to and fro between user space and kernel space */
typedef struct {
  uint32_t reg_data;
  unsigned int address;
} reg_arg_t;

#define CCL_MAGIC 'q'

/* ioctls and their arguments */
#define CCL_WRITE_DATA _IOW(CCL_MAGIC, 1, img_row_arg_t *)
#define CCL_READ_DATA  _IOWR(CCL_MAGIC, 2, img_row_arg_t *)
#define CCL_WRITE_REG  _IOW(CCL_MAGIC, 3, reg_arg_t *)
#define CCL_POLL_REG  _IOWR(CCL_MAGIC, 4, reg_arg_t *)

#endif //_CCL_DD_H
